function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = NK_financial.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(51, 1);
lhs = y(59);
rhs = T(4)*y(20)+T(6)*y(86);
residual(1) = lhs - rhs;
lhs = y(18);
rhs = y(20)+T(6)*y(69);
residual(2) = lhs - rhs;
lhs = y(19);
rhs = y(20)-params(28)*(y(35)-(steady_state(18)))^2+T(6)*y(70);
residual(3) = lhs - rhs;
lhs = y(20);
rhs = T(8)*T(9);
residual(4) = lhs - rhs;
lhs = y(23);
rhs = (1-params(3))*y(2)/(1+T(1))+(1-y(24))*y(26)*y(27);
residual(5) = lhs - rhs;
lhs = y(25);
rhs = (1+T(1))*y(26)/y(3);
residual(6) = lhs - rhs;
lhs = y(24);
rhs = params(8)*(y(25)-1-T(1))^2;
residual(7) = lhs - rhs;
lhs = y(28);
rhs = (y(25)-1-T(1))*2*params(8);
residual(8) = lhs - rhs;
lhs = y(29);
rhs = (1-params(6))*y(20)/T(7)-T(10)/((1+T(1))*y(72)-y(21)*params(7));
residual(9) = lhs - rhs;
lhs = y(30);
rhs = (-y(68))/y(29);
residual(10) = lhs - rhs;
lhs = 1;
rhs = y(32)*y(78)*T(3);
residual(11) = lhs - rhs;
lhs = y(34);
rhs = T(3)*(y(77)+(1-params(3))*y(79));
residual(12) = lhs - rhs;
lhs = 1;
rhs = y(27)*y(34)*(1-y(24)-y(25)*y(28))+T(12)*y(74);
residual(13) = lhs - rhs;
lhs = y(33);
rhs = y(7)/y(36);
residual(14) = lhs - rhs;
lhs = y(68);
rhs = y(20)*(-(1-params(6)))*T(13);
residual(15) = lhs - rhs;
lhs = y(37);
rhs = y(36)*(1+T(1))*y(38)/y(9);
residual(16) = lhs - rhs;
lhs = y(39);
rhs = y(30)*T(14)*y(40)*y(41)+T(3)*(1+T(1))*params(10)*T(17)*y(82);
residual(17) = lhs - rhs;
lhs = y(42);
rhs = y(40)+T(3)*params(10)*T(20)*y(83);
residual(18) = lhs - rhs;
lhs = y(43);
rhs = y(39)/(y(38)*y(42));
residual(19) = lhs - rhs;
lhs = 1;
rhs = params(10)*T(22)^(1-params(5))+(1-params(10))*y(43)^(1-params(5));
residual(20) = lhs - rhs;
lhs = y(44);
rhs = params(10)*T(23)/T(24)*y(11)+(1-params(10))*y(43)^(-params(5));
residual(21) = lhs - rhs;
lhs = y(45);
rhs = T(25)*T(27);
residual(22) = lhs - rhs;
lhs = y(38);
rhs = y(45)*params(2)*y(47)/y(40);
residual(23) = lhs - rhs;
lhs = y(31);
rhs = y(45)*(1-params(2))*y(47)/T(26);
residual(24) = lhs - rhs;
lhs = y(48);
rhs = y(47);
residual(25) = lhs - rhs;
lhs = y(49);
rhs = y(48)*T(29)*y(51)+T(3)*(1+T(1))*params(9)*T(32)*y(84);
residual(26) = lhs - rhs;
lhs = y(52);
rhs = y(50)+T(3)*(1+T(1))*params(9)*T(35)*y(85);
residual(27) = lhs - rhs;
lhs = y(53);
rhs = y(49)/y(52);
residual(28) = lhs - rhs;
lhs = 1;
rhs = params(9)*T(37)^(1-params(4))+(1-params(9))*y(53)^(1-params(4));
residual(29) = lhs - rhs;
lhs = y(54);
rhs = params(9)*T(38)/T(39)*y(15)+(1-params(9))*y(53)^(-params(4));
residual(30) = lhs - rhs;
lhs = log(T(40));
rhs = params(16)*log(T(41))+(1-params(16))*(params(17)*log(T(42))+params(18)*log(T(43))+params(19)*log(T(44)))+log(y(55));
residual(31) = lhs - rhs;
lhs = y(50);
rhs = y(26)+y(21)+y(56);
residual(32) = lhs - rhs;
lhs = y(22);
rhs = y(40)*y(44);
residual(33) = lhs - rhs;
lhs = y(45);
rhs = y(50)*y(54);
residual(34) = lhs - rhs;
lhs = y(57);
rhs = (y(31)+(1-params(3))*y(34))/y(6);
residual(35) = lhs - rhs;
lhs = y(58);
rhs = y(57)-y(33);
residual(36) = lhs - rhs;
lhs = log(y(46))-log((steady_state(29)));
rhs = params(20)*(log(y(12))-log((steady_state(29))))+x(it_, 1);
residual(37) = lhs - rhs;
lhs = log(y(56))-log((steady_state(39)));
rhs = params(21)*(log(y(17))-log((steady_state(39))))+x(it_, 2);
residual(38) = lhs - rhs;
lhs = log(y(51))-log((steady_state(34)));
rhs = params(22)*(log(y(14))-log((steady_state(34))))+x(it_, 3);
residual(39) = lhs - rhs;
lhs = log(y(41))-log((steady_state(24)));
rhs = params(23)*(log(y(10))-log((steady_state(24))))+x(it_, 6);
residual(40) = lhs - rhs;
lhs = log(y(27))-log((steady_state(10)));
rhs = params(26)*(log(y(4))-log((steady_state(10))))+x(it_, 5);
residual(41) = lhs - rhs;
lhs = log(y(55))-log((steady_state(38)));
rhs = params(24)*(log(y(16))-log((steady_state(38))))+x(it_, 4);
residual(42) = lhs - rhs;
lhs = log(y(32))-log((steady_state(15)));
rhs = params(25)*(log(y(5))-log((steady_state(15))))+x(it_, 7);
residual(43) = lhs - rhs;
lhs = y(60);
rhs = log((1+T(1))*T(44));
residual(44) = lhs - rhs;
lhs = y(61);
rhs = log(T(45));
residual(45) = lhs - rhs;
lhs = y(66);
rhs = log(T(46));
residual(46) = lhs - rhs;
lhs = y(67);
rhs = log(T(47));
residual(47) = lhs - rhs;
lhs = y(64);
rhs = (y(40)-(steady_state(23)))/(steady_state(23));
residual(48) = lhs - rhs;
lhs = y(63);
rhs = y(35)-1;
residual(49) = lhs - rhs;
lhs = y(62);
rhs = log(y(36));
residual(50) = lhs - rhs;
lhs = y(65);
rhs = y(58);
residual(51) = lhs - rhs;

end
